/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.discoverers;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Discovery;
import cc.arduino.packages.discoverers.serial.SerialBoardsLister;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;

public class SerialDiscovery
implements Discovery {
    private Timer serialBoardsListerTimer;
    private final List<BoardPort> serialBoardPorts;
    private SerialBoardsLister serialBoardsLister = new SerialBoardsLister(this);

    public SerialDiscovery() {
        this.serialBoardPorts = new LinkedList<BoardPort>();
    }

    @Override
    public List<BoardPort> listDiscoveredBoards() {
        return this.getSerialBoardPorts(false);
    }

    @Override
    public List<BoardPort> listDiscoveredBoards(boolean complete) {
        return this.getSerialBoardPorts(complete);
    }

    private List<BoardPort> getSerialBoardPorts(boolean complete) {
        if (complete) {
            return new LinkedList<BoardPort>(this.serialBoardPorts);
        }
        LinkedList<BoardPort> onlineBoardPorts = new LinkedList<BoardPort>();
        for (BoardPort port : this.serialBoardPorts) {
            if (!port.isOnline()) continue;
            onlineBoardPorts.add(port);
        }
        return onlineBoardPorts;
    }

    public void setSerialBoardPorts(List<BoardPort> newSerialBoardPorts) {
        this.serialBoardPorts.clear();
        this.serialBoardPorts.addAll(newSerialBoardPorts);
    }

    public void forceRefresh() {
        this.serialBoardsLister.retriggerDiscovery(false);
    }

    public void setUploadInProgress(boolean param) {
        this.serialBoardsLister.uploadInProgress = param;
    }

    public void pausePolling(boolean param) {
        this.serialBoardsLister.pausePolling = param;
    }

    @Override
    public void start() {
        this.serialBoardsListerTimer = new Timer(SerialBoardsLister.class.getName());
        this.serialBoardsLister.start(this.serialBoardsListerTimer);
    }

    @Override
    public void stop() {
        this.serialBoardsListerTimer.purge();
    }
}

