/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.BuiltInProperties;
import com.sun.deploy.config.ClientConfig;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.DefaultConfig;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.VersionID;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SecurityBaseline {
    private static String baseline_131 = "1.3.1_99";
    private static String baseline_142 = "1.4.2_43";
    private static String baseline_150 = "1.5.0_99";
    private static String baseline_160 = "1.6.0_171";
    private static String baseline_170 = "1.7.0_161";
    private static String baseline_180 = "1.8.0_151";
    private static String baseline_190 = "1.9.0";
    private static volatile boolean baselines_initialized = false;
    private static final boolean DEBUG = Config.getBooleanProperty("deployment.baseline.debug");
    private static final long UPDATE_INTERVAL = DEBUG ? 10000 : 86400000;
    private static final long THREAD_SLEEP_INTERVAL = DEBUG ? 1000 : 30000;
    private static final String BASELINE_FILENAME = "baseline.versions";
    private static final String SECURITY_PACK_FILENAME = "securitypack.jar";
    private static final String DYNAMIC_BLACKLIST_FILENAME = "blacklist.dynamic";
    private static final String BLACKLIST_CERT_FILENAME = "blacklisted.certs";
    private static final String UPDATE_TIMESTAMP = "update.securitypack.timestamp";
    private static final File securityDir = new File(Config.getLocalOrRoamingUserHome(), "security");
    private static final File securityPackFile = new File(securityDir, "securitypack.jar");
    private static final File baselineFile = new File(securityDir, "baseline.versions");
    private static final File blacklistFile = new File(Config.getDynamicBlacklistFile());
    private static final File blacklistCertsFile = new File(Config.getDynamicBlacklistCertsFile());
    private static final File updateTimestampFile = new File(securityDir, "update.securitypack.timestamp");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void initialize_baselines() {
        block21: {
            if (!baselines_initialized && baselineFile.exists()) {
                BufferedReader bufferedReader;
                block20: {
                    bufferedReader = null;
                    long l = System.currentTimeMillis();
                    bufferedReader = new BufferedReader(new FileReader(baselineFile));
                    boolean bl = false;
                    while (!bl) {
                        String string = bufferedReader.readLine();
                        if (string == null) {
                            bl = true;
                            continue;
                        }
                        if (string.startsWith("1.9")) {
                            baseline_190 = string;
                            Platform.get().cacheSecurityBaseline("1.9.0", baseline_190);
                            continue;
                        }
                        if (string.startsWith("1.8")) {
                            baseline_180 = string;
                            Platform.get().cacheSecurityBaseline("1.8.0", baseline_180);
                            continue;
                        }
                        if (string.startsWith("1.7")) {
                            baseline_170 = string;
                            Platform.get().cacheSecurityBaseline("1.7.0", baseline_170);
                            continue;
                        }
                        if (string.startsWith("1.6")) {
                            baseline_160 = string;
                            Platform.get().cacheSecurityBaseline("1.6.0", baseline_160);
                            continue;
                        }
                        if (string.startsWith("1.5")) {
                            baseline_150 = string;
                            Platform.get().cacheSecurityBaseline("1.5.0", baseline_150);
                            continue;
                        }
                        if (string.startsWith("1.4.2")) {
                            baseline_142 = string;
                            Platform.get().cacheSecurityBaseline("1.4.2", baseline_142);
                            continue;
                        }
                        if (!string.startsWith("1.3.1")) continue;
                        baseline_131 = string;
                        Platform.get().cacheSecurityBaseline("1.3.1", baseline_131);
                    }
                    if (!DEBUG) break block20;
                    Trace.println("It took " + (System.currentTimeMillis() - l) + " Ms. to read baseline file", TraceLevel.BASIC);
                }
                Object var6_5 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    break block21;
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
                break block21;
                {
                    catch (Exception exception) {
                        Trace.ignored(exception);
                        Object var6_6 = null;
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                            break block21;
                        }
                        catch (IOException iOException) {
                            Trace.ignored(iOException);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        Trace.ignored(iOException);
                    }
                    throw throwable;
                }
            }
        }
        baselines_initialized = true;
    }

    public static String getBaselineVersion(String string) {
        if (!baselines_initialized) {
            SecurityBaseline.initialize_baselines();
        }
        String string2 = string.startsWith("1.9") ? baseline_190 : (string.startsWith("1.8") ? baseline_180 : (string.startsWith("1.7") ? baseline_170 : (string.startsWith("1.6") ? baseline_160 : (string.startsWith("1.5") ? baseline_150 : (string.startsWith("1.4.2") ? baseline_142 : (string.startsWith("1.3.1") ? baseline_131 : "1.8.0_151"))))));
        if (DEBUG) {
            Trace.println("for requested version: " + string + "baseline version is: " + string2, TraceLevel.SECURITY);
        }
        return string2;
    }

    public static boolean satisfiesSecurityBaseline(String string) {
        if (!Config.isExpirationCheckEnabled()) {
            return true;
        }
        VersionID versionID = new VersionID(string);
        VersionID versionID2 = new VersionID(SecurityBaseline.getBaselineVersion(string));
        if (versionID.isGreaterThanOrEqual(versionID2)) {
            return true;
        }
        return versionID.equals(JREInfo.getLatestVersion(true));
    }

    public static boolean satisfiesBaselineStrictly(String string) {
        return SecurityBaseline.satisfiesBaselineStrictly(string, SecurityBaseline.getBaselineVersion(string));
    }

    public static boolean satisfiesBaselineStrictly(String string, String string2) {
        if (!SecurityBaseline.getBaselineVersion(string).equals(string2)) {
            return false;
        }
        if (!Config.isExpirationCheckEnabled()) {
            return true;
        }
        int n = (string = string.replace(".ea", "-ea")).indexOf("-");
        String string3 = n > 0 ? string.substring(0, n) : string;
        VersionID versionID = new VersionID(string3);
        VersionID versionID2 = new VersionID(string2);
        boolean bl = versionID.isGreaterThanOrEqual(versionID2);
        if (DEBUG) {
            Trace.println("strictly satisfied=" + bl + "  for version: " + string + "  baseline is: " + SecurityBaseline.getBaselineVersion(string));
        }
        return bl;
    }

    public static String getDeployVersion() {
        return "11.151.2.12";
    }

    public static String getDeployNoBuildVersion() {
        return "11.151.2";
    }

    public static String getDeployNoDotVersion() {
        return "111512";
    }

    public static String getCurrentVersion() {
        return "1.8.0_151";
    }

    public static String getCurrentNoDotVersion() {
        return "180";
    }

    private static synchronized void checkForUpdates(boolean bl) {
        UpdateThread updateThread = new UpdateThread(new Runnable(){

            public void run() {
                UpdateCheckStatus updateCheckStatus = SecurityBaseline.checkForUpdate(Config.getStringProperty("deployment.baseline.url"), securityPackFile);
                if (updateCheckStatus == UpdateCheckStatus.NEW_UPDATE_DOWNLOADED) {
                    Config config;
                    SecurityBaseline.verifyJar(securityPackFile);
                    SecurityBaseline.extractManifests();
                    baselines_initialized = false;
                    SecurityBaseline.initialize_baselines();
                    if (SecurityBaseline.isExpired() && (config = Config.get()) instanceof ClientConfig) {
                        ((ClientConfig)config).storeConfig();
                    }
                }
                if (updateCheckStatus != UpdateCheckStatus.UPDATE_CHECK_FAILED && updateCheckStatus != UpdateCheckStatus.UPDATE_CHECK_SKIPPED) {
                    SecurityBaseline.setLastChecked(new Date().getTime());
                }
            }
        });
        updateThread.setDaemon(!bl);
        updateThread.start();
        try {
            updateThread.join();
        }
        catch (InterruptedException interruptedException) {
            Trace.ignored(interruptedException);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void extractManifests() {
        JarFile jarFile = null;
        jarFile = new JarFile(securityPackFile, false);
        SecurityBaseline.extractManifest(jarFile, BASELINE_FILENAME, baselineFile);
        SecurityBaseline.extractManifest(jarFile, BLACKLIST_CERT_FILENAME, blacklistCertsFile);
        SecurityBaseline.extractManifest(jarFile, DYNAMIC_BLACKLIST_FILENAME, blacklistFile);
        Object var4_1 = null;
        if (jarFile == null) return;
        try {
            jarFile.close();
            return;
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
        }
        return;
        {
            catch (IOException iOException) {
                String string = "Manifest extractions failed for signed security pack file " + securityPackFile;
                Trace.println(string, TraceLevel.SECURITY);
                throw new SecurityException(string, iOException);
            }
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            if (jarFile == null) throw throwable;
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Trace.ignored(iOException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static void verifyJar(File var0) {
        if (Config.isJavaVersionAtLeast16()) {
            block29: {
                var1_1 = new HashSet<CodeSigner>();
                var2_2 = null;
                var3_3 = new String[]{"baseline.versions", "blacklisted.certs", "blacklist.dynamic"};
                var4_4 = null;
                var5_5 /* !! */  = null;
                try {
                    block28: {
                        var2_2 = new JarFile(var0);
                        for (Object var9_12 : var3_3) {
                            var10_13 = null;
                            try {
                                var11_14 = var2_2.getJarEntry((String)var9_12);
                                if (var11_14 == null) {
                                    var12_15 /* !! */  = (byte[])("Verification failed for signed security pack file " + var0 + ", missing entry " + (String)var9_12);
                                    Trace.println((String)var12_15 /* !! */ , TraceLevel.SECURITY);
                                    throw new SecurityException((String)var12_15 /* !! */ , null);
                                }
                                var10_13 = var2_2.getInputStream(var11_14);
                                var12_15 /* !! */  = new byte[1024];
                                while ((var13_16 = var10_13.read(var12_15 /* !! */ )) != -1) {
                                }
                                if (var11_14.getCodeSigners() != null) {
                                    for (CodeSigner var17_20 : var11_14.getCodeSigners()) {
                                        var1_1.add(var17_20);
                                    }
                                }
                                var19_21 = null;
                                if (var10_13 == null) continue;
                            }
                            catch (Throwable var18_23) {
                                var19_21 = null;
                                if (var10_13 != null) {
                                    try {
                                        var10_13.close();
                                    }
                                    catch (IOException var20_22) {
                                        Trace.ignored(var20_22);
                                    }
                                }
                                throw var18_23;
                            }
                            try {
                                var10_13.close();
                            }
                            catch (IOException var20_22) {
                                Trace.ignored(var20_22);
                            }
                        }
                        var6_6 = new ArrayList<E>(var1_1).toArray(new CodeSigner[var1_1.size()]);
                        var7_9 = var0.toURI().toURL();
                        var8_11 = new CodeSource(var7_9, (CodeSigner[])var6_6);
                        var9_12 = TrustDecider.getJarValidationState(var8_11, null, null);
                        if (var9_12.trustDecision == 0L) {
                            var4_4 = "deployment.securitypack.cannot.validate";
                            break block28;
                        }
                        if (var9_12.certValidity != 0) {
                            var4_4 = "deployment.securitypack.cannot.validate";
                            break block28;
                        }
                        if (!var9_12.rootCAValid) {
                            var4_4 = "deployment.securitypack.cannot.validate.selfsigned";
                            break block28;
                        }
                        if (var9_12.timeValid) break block28;
                        var4_4 = "deployment.securitypack.cannot.validate.expired";
                        var5_5 /* !! */  = var9_12.certExpiredException != null ? var9_12.certExpiredException : var9_12.certNotYetValidException;
                    }
                    var22_24 = null;
                    ** if (var2_2 == null) goto lbl-1000
                }
                catch (Throwable var21_30) {
                    var22_26 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (IOException var23_29) {
                            Trace.ignored(var23_29);
                        }
                    }
                    throw var21_30;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var2_2.close();
                    }
                    catch (IOException var23_27) {
                        Trace.ignored(var23_27);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block29;
                    catch (IOException var6_7) {
                        var4_4 = "deployment.securitypack.cannot.validate.exception";
                        var5_5 /* !! */  = var6_7;
                        var22_25 = null;
                        if (var2_2 != null) {
                            try {
                                var2_2.close();
                            }
                            catch (IOException var23_28) {
                                Trace.ignored(var23_28);
                            }
                        }
                    }
                }
            }
            if (var4_4 != null) {
                Trace.println("Verification failed for signed security pack file " + var0, TraceLevel.SECURITY);
                throw new SecurityException(ResourceManager.getMessage(var4_4), var5_5 /* !! */ );
            }
            Trace.println("Verification succeeded for signed security pack file " + var0, TraceLevel.SECURITY);
        } else {
            Trace.println("Security pack verification skipped - not running JDK6 or later", TraceLevel.SECURITY);
        }
    }

    /*
     * Loose catch block
     */
    private static void extractManifest(JarFile jarFile, String string, File file) {
        block17: {
            IOException iOException2222;
            FileOutputStream fileOutputStream;
            InputStream inputStream;
            block16: {
                int n;
                inputStream = null;
                fileOutputStream = null;
                JarEntry jarEntry = jarFile.getJarEntry(string);
                if (jarEntry == null) {
                    String string2 = "Missing  entry " + string;
                    Trace.println(string2, TraceLevel.SECURITY);
                    throw new SecurityException(string2, null);
                }
                if (file.exists() && file.isDirectory()) {
                    SystemUtils.deleteRecursive(file);
                }
                inputStream = jarFile.getInputStream(jarEntry);
                fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                Object var9_11 = null;
                if (fileOutputStream == null) break block16;
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2222) {
                    Trace.ignored(iOException2222);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException2222) {
                    Trace.ignored(iOException2222);
                }
            }
            break block17;
            {
                catch (IOException iOException3) {
                    String string3 = "Failed to extract " + string;
                    Trace.println(string3, TraceLevel.SECURITY);
                    throw new SecurityException(string3, iOException3);
                }
            }
            catch (Throwable throwable) {
                IOException iOException42222;
                Object var9_12 = null;
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException42222) {
                        Trace.ignored(iOException42222);
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException42222) {
                        Trace.ignored(iOException42222);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static UpdateCheckStatus checkForUpdate(String string, File file) {
        UpdateCheckStatus updateCheckStatus;
        block28: {
            if (Platform.get().isScreenLocked()) {
                return UpdateCheckStatus.UPDATE_CHECK_SKIPPED;
            }
            updateCheckStatus = UpdateCheckStatus.UPDATE_NOT_REQUIRED;
            if (string != null && string.length() > 0) {
                Exception exception2222;
                FileOutputStream fileOutputStream;
                InputStream inputStream;
                long l;
                block25: {
                    block24: {
                        int n;
                        long l2 = 0L;
                        l = 0L;
                        if (file.exists()) {
                            l2 = file.lastModified();
                        }
                        inputStream = null;
                        fileOutputStream = null;
                        Trace.println("Checking for update at: " + string, TraceLevel.NETWORK);
                        URL uRL = new URL(string);
                        URLConnection uRLConnection = uRL.openConnection();
                        uRLConnection.setUseCaches(false);
                        l = uRLConnection.getLastModified();
                        if (l < l2) break block24;
                        Trace.println("Updating file at: " + file + " from url: " + string, TraceLevel.NETWORK);
                        inputStream = uRLConnection.getInputStream();
                        fileOutputStream = new FileOutputStream(file);
                        byte[] byArray = new byte[8192];
                        while ((n = inputStream.read(byArray)) != -1) {
                            fileOutputStream.write(byArray, 0, n);
                        }
                        updateCheckStatus = UpdateCheckStatus.NEW_UPDATE_DOWNLOADED;
                    }
                    Object var14_12 = null;
                    if (fileOutputStream == null) break block25;
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception2222) {
                        Trace.ignored(exception2222);
                    }
                    if (l > 0L) {
                        file.setLastModified(l);
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception2222) {
                        Trace.ignored(exception2222);
                    }
                }
                break block28;
                {
                    catch (Exception exception3) {
                        Exception exception42222;
                        updateCheckStatus = UpdateCheckStatus.UPDATE_CHECK_FAILED;
                        Trace.ignored(exception3);
                        Object var14_13 = null;
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Exception exception42222) {
                                Trace.ignored(exception42222);
                            }
                            if (l > 0L) {
                                file.setLastModified(l);
                            }
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception42222) {
                                Trace.ignored(exception42222);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    Exception exception52222;
                    Object var14_14 = null;
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception52222) {
                            Trace.ignored(exception52222);
                        }
                        if (l > 0L) {
                            file.setLastModified(l);
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception52222) {
                            Trace.ignored(exception52222);
                        }
                    }
                    throw throwable;
                }
            }
        }
        return updateCheckStatus;
    }

    private static long getLastChecked() {
        if (updateTimestampFile.exists()) {
            return updateTimestampFile.lastModified();
        }
        return 0L;
    }

    private static void setLastChecked(long l) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(updateTimestampFile);
            ((OutputStream)fileOutputStream).write(46);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void backgroundUpdate() {
        if (Platform.get().isNativeSandbox()) {
            return;
        }
        UpdateThread updateThread = new UpdateThread(new Runnable(){

            public void run() {
                long l = new Date().getTime();
                if (l > SecurityBaseline.getLastChecked() + UPDATE_INTERVAL) {
                    try {
                        Thread.sleep(THREAD_SLEEP_INTERVAL);
                        SecurityBaseline.checkForUpdates(false);
                    }
                    catch (Exception exception) {
                        Trace.ignored(exception);
                    }
                }
                if (DEBUG) {
                    Trace.println("Baseline/Blacklist thread exiting time: " + (new Date().getTime() - l), TraceLevel.BASIC);
                }
            }
        });
        updateThread.setDaemon(true);
        updateThread.start();
    }

    public static void forceBaselineUpdate() {
        SecurityBaseline.checkForUpdates(true);
        SecurityBaseline.initialize_baselines();
    }

    public static boolean isExpired() {
        Comparable<Date> comparable;
        if (!Config.isExpirationCheckEnabled()) {
            return false;
        }
        if (Config.isJavaVersionAtLeast15() && (comparable = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (System.getenv("JRE_NOTEXPIRED") != null) {
                    return Boolean.FALSE;
                }
                if (System.getenv("JRE_EXPIRED") != null) {
                    return Boolean.TRUE;
                }
                return null;
            }
        })) != null) {
            return (Boolean)comparable;
        }
        comparable = new Date(BuiltInProperties.expirationTime);
        if (((Date)comparable).before(new Date())) {
            return true;
        }
        return !SecurityBaseline.satisfiesBaselineStrictly(JREInfo.getLatest());
    }

    public static boolean isUpdateThread() {
        return Thread.currentThread() instanceof UpdateThread;
    }

    static {
        if (Config.get() instanceof DefaultConfig) {
            Trace.ignored(new RuntimeException("Default config is used for security baseline initialization."));
        }
        securityDir.mkdirs();
        SecurityBaseline.backgroundUpdate();
    }

    private static class UpdateThread
    extends Thread {
        UpdateThread(Runnable runnable) {
            super(runnable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum UpdateCheckStatus {
        NEW_UPDATE_DOWNLOADED,
        UPDATE_NOT_REQUIRED,
        UPDATE_CHECK_FAILED,
        UPDATE_CHECK_SKIPPED;

    }
}

