package kr.co.tobby48.medihand.models;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.Valid;
import javax.validation.constraints.Size;

import kr.co.tobby48.medihand.payload.request.appointment.AddAppointmentRequest;

@Entity
@Table(name = "appointment", 
uniqueConstraints = { 
})
public class Appointment {
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	@Size(max = 500)
	private String condition1;
	
	@Size(max = 500)
	private String condition2;

	
	@Size(max = 500)
	private String condition3;

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	@Size(max = 500)
	private String condition4;
	
	@Size(max = 500)
	private String condition5;	//	복수선택
	
	@Size(max = 500)
	private String condition6;	//	복수선택
	
	@Size(max = 500)
	private String condition7;	//	복수선택
	
	@Size(max = 500)
	private String condition8;

	///////////////////////////////////////////////
	
	@Size(max = 500)
	private String condition9;

	@Size(max = 500)
	private String condition10;

	@Size(max = 500)
	private String condition11;

	@Size(max = 500)
	private String condition12;
	///////////////////////////////////////////////
	
	@Size(max = 500)
	private String condition13;
	
	@Column(columnDefinition = "TIMESTAMP DEFAULT CURRENT_TIMESTAMP")
	private Date createdAt;
	///////////////////////////////////////////////

	
//	@NotNull
//	@OneToOne(mappedBy = "appointment")
//	private Management managements;
	
	@OneToOne
	private Management managements;
	
	@Valid
	@ManyToOne
	private User user;

	
	
	public Appointment() {}
	
	public Appointment(AddAppointmentRequest form, User user) {
		setCondition1(form.getCondition1());
		setCondition2(form.getCondition2());
		setCondition3(form.getCondition3());
        
		setCondition4(form.getCondition4());
		setCondition5(form.getCondition5());
		setCondition6(form.getCondition6());
		setCondition7(form.getCondition7());
        
		setCondition8(form.getCondition8());
		setCondition9(form.getCondition9());
		setCondition10(form.getCondition10());
        
		setCondition11(form.getCondition11());
		setCondition12(form.getCondition12());
		setCondition13(form.getCondition13());
//		setManagements(form.getManagement());
        
        setUser(user);
    }
	
	
	public Long getId() {
		return id;
	}
	
	public void setId(Long id) {
		this.id = id;
	}

    public String getCondition1() {
		return condition1;
	}

	public void setCondition1(String condition1) {
		this.condition1 = condition1;
	}

	public String getCondition2() {
		return condition2;
	}

	public void setCondition2(String condition2) {
		this.condition2 = condition2;
	}

	public String getCondition3() {
		return condition3;
	}

	public void setCondition3(String condition3) {
		this.condition3 = condition3;
	}

	public String getCondition4() {
		return condition4;
	}

	public void setCondition4(String condition4) {
		this.condition4 = condition4;
	}

	public String getCondition5() {
		return condition5;
	}

	public void setCondition5(String condition5) {
		this.condition5 = condition5;
	}

	public String getCondition6() {
		return condition6;
	}

	public void setCondition6(String condition6) {
		this.condition6 = condition6;
	}

	public String getCondition7() {
		return condition7;
	}

	public void setCondition7(String condition7) {
		this.condition7 = condition7;
	}

	public String getCondition8() {
		return condition8;
	}

	public void setCondition8(String condition8) {
		this.condition8 = condition8;
	}

	public String getCondition9() {
		return condition9;
	}

	public void setCondition9(String condition9) {
		this.condition9 = condition9;
	}

	public String getCondition10() {
		return condition10;
	}

	public void setCondition10(String condition10) {
		this.condition10 = condition10;
	}

	public String getCondition11() {
		return condition11;
	}

	public void setCondition11(String condition11) {
		this.condition11 = condition11;
	}

	public String getCondition12() {
		return condition12;
	}

	public void setCondition12(String condition12) {
		this.condition12 = condition12;
	}

	public String getCondition13() {
		return condition13;
	}

	public void setCondition13(String condition13) {
		this.condition13 = condition13;
	}

	public Date getCreatedAt() {
		return createdAt;
	}

	public void setCreatedAt(Date createdAt) {
		this.createdAt = createdAt;
	}

	public Management getManagements() {
		return managements;
	}

	public void setManagements(Management managements) {
		this.managements = managements;
	}

	public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }
}
