package kr.co.tobby48.medihand.models;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import kr.co.tobby48.medihand.payload.request.management.AddManagementRequest;

@Entity
@Table(name = "management")
public class Management {
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	//  @Email
//	@NotBlank
//	@NotNull
//	@Size(max = 80)
//	private String title;
//
//	@NotBlank
//	@NotNull
//	@Size(max = 20)
//	private String cellPhone;
//
//	@NotBlank
//	@NotNull
//	@Size(max = 80)
//	private String birthDate;

	@Size(max = 500)
	private String description;
	///////////////////////////////////////////////
	

	@Temporal(TemporalType.TIMESTAMP)
//	@NotBlank
	@NotNull
	private Date startdt;
	
	@Temporal(TemporalType.TIMESTAMP)
//	@NotBlank
	@NotNull
	private Date enddt;
	///////////////////////////////////////////////
	
	@NotNull
	@Enumerated(EnumType.STRING)
	@Column(length = 20)
	private EManagementStatus status;
	
	///////////////////////////////////////////////
	
//	@NotNull
	@Column(columnDefinition = "TIMESTAMP DEFAULT CURRENT_TIMESTAMP")
	private Date createdAt;
	
	@NotNull
	@ManyToOne	//(optional = false, fetch = FetchType.LAZY)
	@JoinColumn(name = "patient_id")
	private Patient patient;
	
//	@NotNull
//	@JsonIgnoreProperties({"hibernateLazyInitializer", "handler"})
//	@OneToOne(cascade = CascadeType.ALL)
//	private Appointment appointment;
//	
//	@OneToOne(cascade = CascadeType.ALL)
//	private Diagnosis diagnosis;
	
	
//	@NotBlank
	@NotNull
	@ManyToOne
	@JoinColumn(name = "user_id")
	private User user;

	
	
	public Management() {
	}
	
	public Management(AddManagementRequest form, User user) {
		setDescription(form.getDescription());
		setStartdt(new Date(form.getStartdt()));
		setEnddt(new Date(form.getEnddt()));
		setStatus(form.getStatus());
		setUser(user);
		setPatient(form.getPatient());
	}
	
	
	public Long getId() {
		return id;
	}
	
	public void setId(Long id) {
		this.id = id;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	@Temporal(TemporalType.TIMESTAMP)
    @Column(nullable = false)
	public Date getStartdt() {
		return startdt;
	}

	public void setStartdt(Date startdt) {
		this.startdt = startdt;
	}

	@Temporal(TemporalType.TIMESTAMP)
    @Column(nullable = false)
	public Date getEnddt() {
		return enddt;
	}

	public void setEnddt(Date enddt) {
		this.enddt = enddt;
	}

	public EManagementStatus getStatus() {
		return status;
	}
	public void setStatus(EManagementStatus status) {
		this.status = status;
	}
	
	public Date getCreatedAt() {
		return createdAt;
	}

	public void setCreatedAt(Date createdAt) {
		this.createdAt = createdAt;
	}
	
	public Patient getPatient() {
		return patient;
	}

	public void setPatient(Patient patient) {
		this.patient = patient;
	}

//	public Appointment getAppointment() {
//		return appointment;
//	}
//
//	public void setAppointment(Appointment appointment) {
//		this.appointment = appointment;
//	}
//	
//	public Diagnosis getDiagnosis() {
//		return diagnosis;
//	}
//
//	public void setDiagnosis(Diagnosis diagnosis) {
//		this.diagnosis = diagnosis;
//	}


	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}
}
