package kr.co.tobby48.medihand.models;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import kr.co.tobby48.medihand.payload.request.patient.AddPatientRequest;

@Entity
@Table(name = "patient", 
uniqueConstraints = { 
		@UniqueConstraint(columnNames = {"lastName", "firstName", "dob"})
})
public class Patient {
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	@NotBlank
	@NotNull
	@Size(max = 80)
	private String lastName;
	
	//  @Email
	@NotBlank
	@NotNull
	@Size(max = 80)
	private String firstName;

	
	@NotBlank
	@NotNull
	@Size(max = 80)
	private String dob;

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	@NotBlank
//	@NotNull
	@Size(max = 1)
	private String sex;
	
//	@NotBlank
//	@NotNull
	@Size(max = 20)
	private String cellPhone;
	
//	@NotBlank
//	@NotNull
	@Size(max = 80)
	private String eName;
	
//	@NotBlank
//	@NotNull
	@Size(max = 50)
	private String eRelationShip;
	
//	@NotBlank
//	@NotNull
	@Size(max = 20)
	private String ePhone;

	///////////////////////////////////////////////
	
//	@NotBlank
//	@NotNull
	@Size(max = 200)
	private String address;

//	@NotBlank
//	@NotNull
	@Size(max = 50)
	private String city;

//	@NotBlank
//	@NotNull
	@Size(max = 20)
	private String state;

//	@NotBlank
//	@NotNull
	@Size(max = 20)
	private String zipCode;
	///////////////////////////////////////////////
	
	@Size(max = 20)
	private String homePhone;
	
	@Size(max = 100)
	private String email;
	///////////////////////////////////////////////
	
//	@NotBlank
//	@NotNull
	@Size(max = 300)
	private String note;

	@Size(max = 50)
	private String ssn;
	
	@Size(max = 200)
	private String referring;
	///////////////////////////////////////////////
	
	@Size(max = 100)
	private String insuFirst;
	
	@Size(max = 100)
	private String insuTwo;
	
	@Size(max = 100)
	private String insuThree;
	
	@Size(max = 100)
	private String insuFour;
	
	@Size(max = 100)
	private String insuFive;
	
	@Size(max = 100)
	private String insuSix;
	///////////////////////////////////////////////
	
//	@NotNull
	@Column(columnDefinition = "TIMESTAMP DEFAULT CURRENT_TIMESTAMP")
	private Date createdAt;
	///////////////////////////////////////////////
	
	
	@OneToMany(mappedBy = "patient")
	private Set<Management> managements = new HashSet<>();
	
//	@NotBlank
//	@NotNull
	@Valid
	@ManyToOne
	@JoinColumn(name = "user_id")
	private User user;

	
	
	public Patient() {}
	
	public Patient(AddPatientRequest form, User user) {
		setFirstName(form.getFirstName());
		setLastName(form.getLastName());
        setSex(form.getSex());
        
        setAddress(form.getAddress());
        setCity(form.getCity());
        setState(form.getState());
        setZipCode(form.getZipCode());
        
        setHomePhone(form.getHomePhone());
        setCellPhone(form.getCellPhone());
        setEmail(form.getEmail());
        
        setDob(form.getDob());
        setNote(form.getNote());
        
        setSsn(form.getSsn());
        setReferring(form.getReferring());
        
        seteName(form.geteName());
        seteRelationShip(form.geteRelationShip());
        setePhone(form.getePhone());
        
        setInsuFirst(form.getInsuFirst());
        setInsuTwo(form.getInsuTwo());
        setInsuThree(form.getInsuThree());
        setInsuFour(form.getInsuFour());
        setInsuFive(form.getInsuFive());
        setInsuSix(form.getInsuSix());
        
        setUser(user);
    }
	
	
	
	public Long getId() {
		return id;
	}
	
	public void setId(Long id) {
		this.id = id;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getSex() {
		return sex;
	}

	public void setSex(String sex) {
		this.sex = sex;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getZipCode() {
		return zipCode;
	}

	public void setZipCode(String zipCode) {
		this.zipCode = zipCode;
	}

	public String getHomePhone() {
		return homePhone;
	}

	public void setHomePhone(String homePhone) {
		this.homePhone = homePhone;
	}

	public String getCellPhone() {
		return cellPhone;
	}

	public void setCellPhone(String cellPhone) {
		this.cellPhone = cellPhone;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getDob() {
		return dob;
	}

	public void setDob(String dob) {
		this.dob = dob;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}
	
	public Date getCreatedAt() {
		return createdAt;
	}

	public void setCreatedAt(Date createdAt) {
		this.createdAt = createdAt;
	}

	public String getSsn() {
		return ssn;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}

	public String getReferring() {
		return referring;
	}

	public void setReferring(String referring) {
		this.referring = referring;
	}

	public String geteName() {
		return eName;
	}

	public void seteName(String eName) {
		this.eName = eName;
	}

	public String geteRelationShip() {
		return eRelationShip;
	}

	public void seteRelationShip(String eRelationShip) {
		this.eRelationShip = eRelationShip;
	}

	public String getePhone() {
		return ePhone;
	}

	public void setePhone(String ePhone) {
		this.ePhone = ePhone;
	}

	public String getInsuFirst() {
		return insuFirst;
	}

	public void setInsuFirst(String insuFirst) {
		this.insuFirst = insuFirst;
	}

	public String getInsuTwo() {
		return insuTwo;
	}

	public void setInsuTwo(String insuTwo) {
		this.insuTwo = insuTwo;
	}

	public String getInsuThree() {
		return insuThree;
	}

	public void setInsuThree(String insuThree) {
		this.insuThree = insuThree;
	}

	public String getInsuFour() {
		return insuFour;
	}

	public void setInsuFour(String insuFour) {
		this.insuFour = insuFour;
	}

	public String getInsuFive() {
		return insuFive;
	}

	public void setInsuFive(String insuFive) {
		this.insuFive = insuFive;
	}

	public String getInsuSix() {
		return insuSix;
	}

	public void setInsuSix(String insuSix) {
		this.insuSix = insuSix;
	}

    public Set<Management> getManagements() {
		return managements;
	}

	public void setManagements(Set<Management> managements) {
		this.managements = managements;
	}

	public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }
}
