package kr.co.tobby48.medihand.models;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.Valid;
import javax.validation.constraints.Size;

import kr.co.tobby48.medihand.payload.request.diagnosis.AddDiagnosisRequest;

@Entity
@Table(name = "prescription", 
uniqueConstraints = { 
})
public class Prescription {
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	@Size(max = 500)
	private String condition1;
	
	@Size(max = 500)
	private String condition2;

	
	@Size(max = 500)
	private String condition3;

	
	@Column(columnDefinition = "TIMESTAMP DEFAULT CURRENT_TIMESTAMP")
	private Date createdAt;
	///////////////////////////////////////////////

	
//	@NotNull
	@OneToOne
	private Management managements;
	
//	@OneToOne(cascade = CascadeType.ALL)
//	private Prescription prescription;
	
	@Valid
	@ManyToOne
	private User user;

	
	
	public Prescription() {}
	
	public Prescription(AddDiagnosisRequest form, User user) {
		setCondition1(form.getCondition1());
		setCondition2(form.getCondition2());
		setCondition3(form.getCondition3());
        
//		setManagements(form.getManagement());
        
        setUser(user);
    }
	
	
	public Long getId() {
		return id;
	}
	
	public void setId(Long id) {
		this.id = id;
	}

    public String getCondition1() {
		return condition1;
	}

	public void setCondition1(String condition1) {
		this.condition1 = condition1;
	}

	public String getCondition2() {
		return condition2;
	}

	public void setCondition2(String condition2) {
		this.condition2 = condition2;
	}

	public String getCondition3() {
		return condition3;
	}

	public void setCondition3(String condition3) {
		this.condition3 = condition3;
	}

	public Date getCreatedAt() {
		return createdAt;
	}

	public void setCreatedAt(Date createdAt) {
		this.createdAt = createdAt;
	}

	public Management getManagements() {
		return managements;
	}

	public void setManagements(Management managements) {
		this.managements = managements;
	}

	public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }
}
