package kr.co.tobby48.medihand.payload.request.management; 

import java.io.Serializable;
import java.util.Date;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import kr.co.tobby48.medihand.models.Management;

/**
 * <pre>
 * kr.co.tobby48.medihand.payload.form 
 * UpdateManagementForm.java
 *
 * 설명 :
 * </pre>
 * 
 * @since : 2022. 10. 22.
 * @author : tobby48
 * @version : v1.0
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class UpdateManagementRequest extends AddManagementRequest implements Serializable {


    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	@NotNull(message = "{validation.id.required}")
	private Long id;
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}
	
	public Management update(Management management) {
		management.setDescription(getDescription());
		management.setStatus(getStatus());
		management.setStartdt(new Date(getStartdt()));
		management.setEnddt(new Date(getEnddt()));
		management.setPatient(getPatient());
		
		return management;
	}

}