package kr.co.tobby48.medihand.payload.request.patient; 

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import kr.co.tobby48.medihand.models.Patient;

/**
 * <pre>
 * kr.co.tobby48.medihand.payload.form 
 * UpdatePatientForm.java
 *
 * 설명 :
 * </pre>
 * 
 * @since : 2022. 10. 22.
 * @author : tobby48
 * @version : v1.0
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class UpdatePatientRequest extends AddPatientRequest implements Serializable {


    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	@NotNull(message = "{validation.id.required}")
	private Long id;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}
	
	public Patient update(Patient patient) {
		patient.setFirstName(getFirstName());
		patient.setLastName(getLastName());
		patient.setSex(getSex());
        
		patient.setAddress(getAddress());
		patient.setCity(getCity());
		patient.setState(getState());
		patient.setZipCode(getZipCode());
        
		patient.setHomePhone(getHomePhone());
		patient.setCellPhone(getCellPhone());
		patient.setEmail(getEmail());
        
		patient.setDob(getDob());
		patient.setNote(getNote());
        
		patient.setSsn(getSsn());
		patient.setReferring(getReferring());
        
		patient.seteName(geteName());
		patient.seteRelationShip(geteRelationShip());
		patient.setePhone(getePhone());
        
		patient.setInsuFirst(getInsuFirst());
		patient.setInsuTwo(getInsuTwo());
		patient.setInsuThree(getInsuThree());
		patient.setInsuFour(getInsuFour());
		patient.setInsuFive(getInsuFive());
		patient.setInsuSix(getInsuSix());
		
		return patient;
	}
}