package kr.co.tobby48.medihand.payload.response.management;

import java.util.Date;

import kr.co.tobby48.medihand.models.Appointment;
import kr.co.tobby48.medihand.models.EManagementStatus;
import kr.co.tobby48.medihand.models.Management;
import kr.co.tobby48.medihand.models.Patient;

public class ManagementCommonResponse implements Comparable<ManagementCommonResponse>{
	private Long id;
	private String description;
	private Date startdt;
	private Date enddt;
	private Patient patient;
//	private Appointment appointment;
	private EManagementStatus status;

	//	db 저장하지 않음
	private String type = "draggable";
	private Boolean loading =  false;
	
	public ManagementCommonResponse(Management management, EManagementStatus status) {
		this.id = management.getId();
		this.description = management.getDescription();
		
		this.startdt = management.getStartdt();
		this.enddt = management.getEnddt();
		this.status = status;
		this.patient = management.getPatient();
//		this.appointment = management.getAppointment();
	}

	
	public Long getId() {
		return id;
	}


	public void setId(Long id) {
		this.id = id;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Date getStartdt() {
		return startdt;
	}

	public void setStartdt(Date startdt) {
		this.startdt = startdt;
	}

	public Date getEnddt() {
		return enddt;
	}

	public void setEnddt(Date enddt) {
		this.enddt = enddt;
	}

	public Patient getPatient() {
		return patient;
	}

	public void setPatient(Patient patient) {
		this.patient = patient;
	}

	public EManagementStatus getStatus() {
		return status;
	}

	public void setStatus(EManagementStatus status) {
		this.status = status;
	}

	
	public String getType() {
		return type;
	}


	public void setType(String type) {
		this.type = type;
	}


	public Boolean getLoading() {
		return loading;
	}


	public void setLoading(Boolean loading) {
		this.loading = loading;
	}

	
//	public Appointment getAppointment() {
//		return appointment;
//	}
//
//
//	public void setAppointment(Appointment appointment) {
//		this.appointment = appointment;
//	}


	@Override
	public int compareTo(ManagementCommonResponse o) {
		// TODO Auto-generated method stub
		return startdt.getTime() > o.getStartdt().getTime() ? 1 : -1;
	}

}
