import { createApp } from "vue";
import { createPinia } from "pinia";

// styles
import "@fortawesome/fontawesome-free/css/all.min.css";
import "aos/dist/aos.css";
import '@/assets/css/main.css'

import Vue3EasyDataTable from 'vue3-easy-data-table';
import 'vue3-easy-data-table/dist/style.css';

import VueDragscroll from "vue-dragscroll";


// mouting point for the whole app
import App from "@/App.vue";

// routes
import router from "./router";
import store from "./store";
import LoadScript from 'vue-plugin-load-script';


createApp(App)
  .use(router)
  .use(store)
  .use(LoadScript)
  .use(VueDragscroll)
  .use(createPinia())
  .component('EasyDataTable', Vue3EasyDataTable)
  .mount("#app");
