import { createWebHistory, createRouter } from "vue-router";
import store from "./store";

import AboutUs from "./views/landing/AboutUs.vue";
import TimeTable from "./views/landing/TimeTable.vue";
import Clinic from "./views/landing/Clinic.vue";
import ClinicDetail from "./views/landing/ClinicDetail.vue";
import Testimonial from "./views/landing/Testimonial.vue";
import TestimonialDetail from "./views/landing/TestimonialDetail.vue";
import Contact from "./views/landing/Contact.vue";
import Login from "./views/landing/Login.vue";
import Register from "./views/landing/Register.vue";

import Landing from "./views/landing/Landing.vue";


import DashBoard from "./views/admin/DashBoard.vue";
import Appointment from "./views/admin/Appointment.vue";
// import Management from "./views/admin/Management.vue";
import Manage from './views/admin/Manage.vue'
import Patients from "./views/admin/Patients.vue";
import Profile from "./views/admin/Profile.vue";
// import NotFound from './views/NotFound.vue'



// lazy-loaded
// const Profile = () => import("./components/Profile.vue")
// const BoardAdmin = () => import("./components/BoardAdmin.vue")
// const BoardModerator = () => import("./components/BoardModerator.vue")
// const BoardUser = () => import("./components/BoardUser.vue")
// const BoardMap = () => import("./components/BoardMap.vue")


const routes = [
  {
    path: "/",
    name: "home",
    component: Landing,
  },
  {
    path: "/aboutus",
    component: AboutUs,
  },
  {
    path: "/timetable",
    component: TimeTable,
  },
  {
    path: "/clinic",
    component: Clinic,
  },
  {
    path: "/clinic/:id",
    component: ClinicDetail,
  },
  {
    path: "/testimonial",
    component: Testimonial,
  },
  {
    path: "/testimonial/:id/:titleId",
    component: TestimonialDetail,
  },
  {
    path: "/contact",
    component: Contact,
  },
  {
    path: "/login",
    component: Login,
  },
  {
    path: "/register",
    component: Register,
  },
  {
    path: "/admin/dashboard",
    name: "dashboard",
    // lazy-loaded
    component: DashBoard,
    meta: {
      requiresAuth: true
    }
  },
  {
    path: "/admin/manage",
    name: "manage",
    // lazy-loaded
    component: Manage,
    meta: {
      requiresAuth: true
    }
  },
  {
    path: "/admin/appointment",
    name: "appointment",
    // lazy-loaded
    component: Appointment,
    meta: {
      requiresAuth: true
    }
  },
  // {
  //   path: "/admin/management",
  //   name: "management",
  //   // lazy-loaded
  //   component: Management,
  //   meta: {
  //     requiresAuth: true
  //   }
  // },
  {
    path: "/admin/patients",
    name: "patients",
    // lazy-loaded
    component: Patients,
    meta: {
      requiresAuth: true
    }
  },
  {
    path: "/admin/profile",
    name: "profile",
    // lazy-loaded
    component: Profile,
    meta: {
      requiresAuth: true
    }
  },
  // {
	//   path: '/:pathMatch(.*)*',
	//   name: '404',
	//   component: NotFound,
  // }


];
// const scrollBehavior = function (to, from, savedPosition) {
//   if (to.hash) {
//     return {
//       selector: to.hash,
//       offset: { x: 0, y: -500 }
//     }
//   }
//   return { x: 0, y: 0 };
// }

const router = createRouter({
  history: createWebHistory(),
  // scrollBehavior,
  routes,
});

//Navigation Guards
router.beforeEach((to, from, next) => {
  // store.state.isNavChildDropdown = true;
  // console.log(store.state.isNavChildDropdown);
  if (to.matched.some(record => record.meta.requiresAuth)) {
    // console.log(store.state.auth.user);
    if (store.state.auth.user && store.state.auth.user['roles'] && store.state.auth.user['roles'].includes('ROLE_ADMIN')) {
      next();
    } else {
      next("login");
    }
  } else {
      next();
  }
});

router.afterEach((to, from, failure) => {
  // store.state.isNavChildDropdown = true;
  // console.log(store.state.isNavChildDropdown);
})

// router.beforeEach((to, from, next) => {
//   const publicPages = ['/admin/dashboard', '/admin/appointment', '/admin/management'];
//   const authRequired = !publicPages.includes(to.path);
//   const loggedIn = localStorage.getItem('user');

//   // trying to access a restricted page + not logged in
//   // redirect to login page
//   if (authRequired && !loggedIn) {
//     next('/login');
//   } else {
//     next();
//   }
// });

export default router;