import axios from 'axios';

import YELP from './utils/yelp';
import GOOGLE from './utils/google-place';

class LandingService {
    async reviews() {
        var reviews = [];
        var yelpReviews = await YELP.reviews();
        var googleReviews = await GOOGLE.reviews();
        reviews.push(...yelpReviews);
        reviews.push(...googleReviews);
        reviews.sort(function(a, b){
            var keyA = new Date(a.time),
                keyB = new Date(b.time);
            // Compare the 2 dates
            if(keyA < keyB) return 1;
            if(keyA > keyB) return -1;
            return 0;
        });
        return reviews;
    }
  
}

export default new LandingService();
