import axios from 'axios';

const API_URL = '/api/management/';

class ManagementService {
  allLoad(userId) {
    return axios.get(API_URL + userId + "/all")
      .then(response => {
        return response.data;
      });
  }
  statistic(userId) {
    return axios.get(API_URL + userId + "/statistic")
      .then(response => {
        return response.data;
      });
  }



  todayLoad(userId) {
    return axios.get(API_URL + userId)
      .then(response => {
        return response.data;
      });
  }

  loadByStatus(userId, status) {
    return axios.get(API_URL + userId + "/" + status)
      .then(response => {
        return response.data;
      });
  }

  save(management) {
    return axios
      .post(API_URL, management)
      .then(response => {
        return response.data;
      });
  }

  update(management) {
    return axios
      .put(API_URL, management)
      .then(response => {
        return response.data;
      });
  }

  delete(managementId) {
    return axios
      .delete(API_URL + managementId)
      .then(response => {
        return response.data;
      });
  }

}

export default new ManagementService();
