import axios from 'axios';

const API_URL = '/api/patient/';

class PatientService {
  load(userId) {
    return axios.get(API_URL + userId)
      .then(response => {
        return response.data;
      });
  }

  save(patient) {
    return axios
      .post(API_URL, patient)
      .then(response => {
        return response.data;
      });
  }

  update(patient) {
    return axios
      .put(API_URL, patient)
      .then(response => {
        return response.data;
      });
  }

  delete(patientId) {
    return axios
      .delete(API_URL + patientId)
      .then(response => {
        return response.data;
      });
  }

}

export default new PatientService();
