import axios from 'axios';
import authHeader from './auth-header';

const API_URL = '/api/test/';
const USER_API_URL = '/api/user/';

class UserService {
  getUsers() {
    return axios.get(USER_API_URL);
  }
  findUserByUserName(username) {
    return axios.get(USER_API_URL + username);
  }
  updateUser(user) {
    return axios.put(USER_API_URL, user);
  }

  getPublicContent() {
    return axios.get(API_URL + 'all');
  }

  getUserBoard() {
    return axios.get(API_URL + 'user', { headers: authHeader() });
  }

  getModeratorBoard() {
    return axios.get(API_URL + 'mod', { headers: authHeader() });
  }

  getAdminBoard() {
    return axios.get(API_URL + 'admin', { headers: authHeader() });
  }
}

export default new UserService();
