import axios from 'axios';


/* eslint-disable */

function sort_by_date(ray) {
    ray.sort(function(a, b){
        var keyA = new Date(a.time),
            keyB = new Date(b.time);
        // Compare the 2 dates
        if(keyA < keyB) return -1;
        if(keyA > keyB) return 1;
        return 0;
    });
    return ray;
}

function filter_minimum_rating(reviews) {
    for (var i = reviews.length -1; i >= 0; i--) {
        if(reviews[i].rating < plugin.settings.min_rating){
            reviews.splice(i,1);
        }
    }
    return reviews;
}


function truncate(string){
    if (string.length > 189)
        return string.substring(0,189)+'...';
    else
        return string;
};

function renderStars(rating) {
    var stars = "<div class='review-stars'><ul>";

    // fill in gold stars
    for (var i = 0; i < rating; i++) {
        stars = stars+"<li><i class='star'></i></li>";
    };

    // fill in empty stars
    if(rating < 5){
        for (var i = 0; i < (5 - rating); i++) {
            stars = stars+"<li><i class='star inactive'></i></li>";
        };
    }
    stars = stars+"</ul></div>";
    return stars;
}

function convertTime(UNIX_timestamp) {
    var a = new Date(UNIX_timestamp * 1000);
    var months = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
    var time = months[a.getMonth()] + ' ' + a.getDate() + ', ' + a.getFullYear();
    return time;
}

const reviews = function() {
    var defaults = {
        placeId: 'ChIJ65anG27SwoARTkmc4Fc_odA' // placeId provided by google api documentation
        , render: ['reviews']
        , min_rating: 4
        , max_rows: 7
        , rotateTime: false
    };
    
    var plugin = {
            settings: defaults,
            place_data: {}
    };
    // var $element = this.$refs.googlereviews;
    var $element = document.querySelector('#googlereviews');

    // plugin.settings = $.extend({}, defaults);
    plugin.settings = defaults;
    // $element.html("<div id='map-plug'></div>"); // create a plug for google to load data into
    var map = new google.maps.Map(document.getElementById('map-plug'));
    var request = {
        placeId: plugin.settings.placeId
    };
    var mapService = new google.maps.places.PlacesService(map);
    return new Promise(function (resolve, reject) {
        mapService.getDetails(request, function(place, status) {
            var reviewsItems = [];
            if (status == google.maps.places.PlacesServiceStatus.OK) {
                plugin.place_data = place;
                // render specified sections
                if(plugin.settings.render.indexOf('reviews') > -1){
                    var reviews = plugin.place_data.reviews;
                    //reviews = sort_by_date(reviews);
                    //reviews = filter_minimum_rating(reviews);
                    var row_count = (plugin.settings.max_rows > 0)? plugin.settings.max_rows - 1 : reviews.length - 1;
                    // make sure the row_count is not greater than available records
                    row_count = (row_count > reviews.length-1)? reviews.length -1 : row_count;
                    for (var i = row_count; i >= 0; i--) {
                        var stars = renderStars(reviews[i].rating);
                        var date = convertTime(reviews[i].time);
                        var reviewItem = {
                                social : 2,
                                profile_photo_url : reviews[i].profile_photo_url,
                                author_name : reviews[i].author_name,
                                date : date,
                                time : Date.parse(date),
                                rating : reviews[i].rating,
                                text : reviews[i].text
                        }
                        reviewsItems.push(reviewItem);
                    };
                    resolve(reviewsItems);
                }
            }
        });
    });
}

export default {
    reviews,
    // the other functions
}
