import axios from 'axios';

const yelp = {
  businessId: 'medihand-acupuncture-clinic-pico-rivera-2',
  apiKey: 'TKZgETJ1yg3sruR1QOzrbtP31RbSmRWe7nCQnzadI-UFgG2lTiYxSLGCmDedFIYhrFMI6hSquCnx8ClTAhAiX1c5iK4fNxjtrDpoUTgeaAKI8HTqyz4g9HAQYyZ7YnYx',
}
export const landing = {
  namespaced: true,
  state: {
    yelpLoaded: false,
    yelpReviewsItems: []
  },
  actions: {
    yelp({ commit }) {
      return axios
                .get('/api/home/yelp/' + yelp.businessId + '/' + yelp.apiKey)
                .then(response => {
                  let reviewsItems = [];
                  for (var i = 0; i < response.data.reviews.length; i++) {
                    var reviewItem = {
                        social : 1,
                        profile_photo_url : response.data.reviews[i].user.image_url,
                        author_name : response.data.reviews[i].user.name,
                        date : response.data.reviews[i].time_created,
                        rating : response.data.reviews[i].rating,
                        text : response.data.reviews[i].text
                        }
                    reviewItem.time = Date.parse(response.data.reviews[i].time_created);
                    reviewsItems.push(reviewItem);
                  }
                  return reviewsItems;
                })
                .then(
                  reviewsItems => {
                    commit('yelpSuccess', reviewsItems);
                    return Promise.resolve(reviewsItems);
                  },
                  error => {
                    commit('yelpFailure');
                    return Promise.reject(error);
                  }
                );
    },
    
  },
  mutations: {
    yelpSuccess(state, reviewsItems) {
      state.yelpLoaded = true;
      state.yelpReviewsItems = reviewsItems;
    },
    yelpFailure(state) {
      state.yelpLoaded = false;
      state.yelpReviewsItems = [];
    },
  }
};
