import { defineStore } from "pinia";

export const useSystemStore = defineStore({
  id: "system",
  state: () => ({
    taskView: false,
    taskForm: {
      visible: false,
      edit: false,
      searchType: true
    },
    boardForm: {
      visible: false,
      edit: false,
    },
    delete: {
      visible: false,
      board: false,
    },
    patientForm: {
      visible: false,
      edit: false,
    },
    appointmentForm: {
      visible: false,
      edit: false,
    },


    historyView: false,
    appointmentTaskForm: {
      visible: false,
      edit: false,
    },
    diagnosisTaskForm: {
      visible: false,
      edit: false,
    },
    prescriptionTaskForm: {
      visible: false,
      edit: false,
    },
    completionTaskForm: {
      visible: false,
      edit: false,
    },
    
    pdfForm: {
      visible: false
    },
    
    sidebar: true,
    sidebarMobile: false,
    overlay: false,
    dragging: false,
    darkmode: false,
  }),
  getters: {},
  actions: {
    hideOverlay() {
      this.overlay = false;
      this.taskView = false;
      this.taskForm.visible = false;
      this.boardForm.visible = false;
      this.delete.visible = false;

      this.patientForm.visible = false;
      this.appointmentForm.visible = false;

      this.historyView = false;
      this.appointmentTaskForm.visible = false;
      this.diagnosisTaskForm.visible = false;
      this.prescriptionTaskForm.visible = false;
      this.completionTaskForm.visible = false;

      this.pdfForm.visible = false;
      this.sidebarMobile = false;
      this.sidebar = true;
    },
  },
});
