/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    './src/assets/**/*.{vue,js,css}',
    './src/components/**/*.{vue,js}',
    './src/services/**/*.{vue,js}',
    './src/store/**/*.vue',
    './src/views/**/*.vue',
    './src/plugins/**/*.{js,ts}',
    "./src/**/*.{vue,js,ts,jsx,tsx}"
    
  ],
  darkMode:'class',
  theme: {
    maxWidth: {
      '3xs': '16.5rem',
      'xs': '21.5rem',
      'md': '30rem'
    },
    fontSize: {
      'xs': '.75rem',
      'sm': '.8rem',
      'base': '.94rem',
      'lg': '1.125rem',
      'xl': '1.25rem',
      '2xl': '1.5rem',
      '3xl': '1.875rem',
      '4xl': '2.25rem',
      '5xl': '3rem',
      '6xl': '4rem',
      '7xl': '5rem',
    },
    extend: {
      colors: {
        "main-purple": "#635FC7",
        "main-purple-light": "#A8A4FF",
        "black": "#000112",
        "very-dark-grey": "#20212C",
        "dark-grey": "#2B2C37",
        "medium-grey": "#828FA3",
        "light-grey": "#F4F7FD",
        "lines-dark": "#3E3F4E",
        "lines-light": "#E4EBFA",
        "red": "#EA5555",
        "red-light": "#FF9898",
        "white": "#FFFFFF",
  
        "light-medium-grey": "#d1d5db",
        "red-medium": "#f87171",
        "blue-medium": "#60a5fa",
        "green-medium": "#4ade80",
        "pink-medium": "#db2777",
        "amber-medium": "#fbbf24",
        "yellow-medium": "#facc15",
        "violet-medium": "#c4b5fd",
        "rose-medium": "#f43f5e",
        "orange-medium": "#f97316",
        "lightBlue-medium": "#03a9f4",
  
        "emerald-500": "#10b981",
        "lightBlue-500": "#03a9f4",
        "red-500": "#ef4444",
        // "orange-500": "#f97316",
        // "purple-500": "#a855f7",
  
        "emerald-200": "#a7f3d0",
        "lightBlue-200": "#81d4fa",
        "red-200": "#fecaca",
        // "orange-200": "#fed7aa",
        // "purple-200": "#e9d5ff",
        "blueGray-800": "#1e293b",
        "blueGray-100": "#f1f5f9",

      },
      boxShadow: {
        'task': '0 4px 6px 0px rgba(54, 78, 126, 0.1)',
      },
      spacing: {
        '4.5': '1.125rem'
      }
    },
    screens: {
      'sm': '640px',
      // => @media (min-width: 640px) { ... }

      'md': '768px',
      // => @media (min-width: 768px) { ... }

      'lg': '1024px',
      // => @media (min-width: 1024px) { ... }

      'xl': '1280px',
      // => @media (min-width: 1280px) { ... }

      '2xl': '1536px',
      // => @media (min-width: 1536px) { ... }
    }
  },
  plugins: [
    require("daisyui"),
  ],

  daisyui: {
    themes: ["light", "dark", "cupcake", "bumblebee", "emerald", "corporate", "synthwave", "retro", "cyberpunk", "valentine", "halloween", "garden", "forest", "aqua", "lofi", "pastel", "fantasy", "wireframe", "black", "luxury", "dracula", "cmyk", "autumn", "business", "acid", "lemonade", "night", "coffee", "winter"],
  },
}
