import sys
from PyQt5.QtWidgets import *
from PyQt5 import uic
from PyQt5.QtCore import *
import socket
import json
import threading



class loginWindow(QWidget):
    def __init__(self):
        super().__init__()
        self.initUI()

    def initUI(self):
        self.setWindowTitle('채팅방 로그인')

        centerGeometry = QDesktopWidget().availableGeometry().center()
        self.resize(300, 100)
        frameGeometry = self.frameGeometry()
        frameGeometry.moveCenter(centerGeometry)

        idLabel = QLabel("아이디 : ")
        self.idLineEdit = QLineEdit()
        loginButton = QPushButton("로그인")

        layout = QGridLayout()

        layout.addWidget(idLabel, 0, 0)
        layout.addWidget(self.idLineEdit, 0, 1)
        layout.addWidget(loginButton, 0, 2)

        self.setLayout(layout)

        loginButton.clicked.connect(self.logged_in)


    def logged_in(self):
        self.cli_dict = dict()
        self.cli_dict['ID'] = self.idLineEdit.text()

        self.chatwindow = chatWindow()
        self.hide()
        self.chatwindow.show()


form = uic.loadUiType("qtdesign.ui")[0]

class chatWindow(QMainWindow, form):
    def __init__(self):
        super().__init__()
        self.setupUi(self)

        self.socket_s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        self.socket_s.connect(('127.0.0.1', 4000))
        th = threading.Thread(target=self.worker, name="[스레드 이름 {}]".format(self.socket_s), args=(self.socket_s,))
        th.start()

        self.ID = logwindow.cli_dict['ID']
        self.pushButton.clicked.connect(self.button2Clicked)

    def worker(self,conn):
        while True:
            recv_part = conn.recv(4)
            recv_part2 = int(recv_part.decode())
            data = conn.recv(recv_part2)
            self.data_loads = json.loads(data.decode())
            # self.msg = self.data_loads['ID'] , '>', self.data_loads['msg']
            self.msg = self.data_loads['ID'] + ":" + self.data_loads['msg'] + "\n"
            self.plainTextEdit.insertPlainText(self.msg)
        conn.close()


    def button2Clicked(self):
        self.send_dict = dict()
        self.send_dict["ID"] = self.ID
        self.send_dict["msg"] = self.lineEdit.text()
        self.jsend_dict = json.dumps(self.send_dict)
        self.f_dict = str(len(self.jsend_dict.encode())).zfill(4) + self.jsend_dict
        self.socket_s.send(self.f_dict.encode())
        self.lineEdit.clear()



if __name__ == "__main__":
    app = QApplication(sys.argv)
    logwindow = loginWindow()
    logwindow.show()
    sys.exit(app.exec_())












# import requests
# from bs4 import BeautifulSoup  # BeautifulSoup import
# from konlpy.tag import Kkma
# import t
# kkma = Kkma()
# def ana(a,d):
#     ur = a
#     response = requests.get(headers={'User-Agent': 'Mozilla/5.0'},url=ur)
#     html = response.text
#     soup = BeautifulSoup(html, 'html.parser')  # html.parser를 사용해서 soup에 넣겠다
#     for tag in soup.select('div[id=dic_area]'):
#         t1=tag.text
#     mo = kkma.morphs(t1)
#
#
#     b=t.news2(mo ,d)
#
#     return b