import sys
from PyQt5.QtWidgets import *
from PyQt5 import uic
import csv_des

form = uic.loadUiType("pyqt_des_ui.ui")[0]


class MyWindow(QMainWindow, form):
    def __init__(self):
        super().__init__()
        self.setupUi(self)

        self.cal.clicked.connect(self.get_Date)
        self.pushButton.clicked.connect(self.search)

    def get_Date(self):
        # self.cal = QCalendarWidget
        # self.cal.selectedDate()

        self.date = self.cal.selectedDate().toString()
        self.date2 = self.date[3:6].strip()

        self.fix_date = str(self.cal.yearShown()) + str(self.cal.monthShown()).zfill(2) + self.date2.zfill(2)
        print(self.fix_date)

    def search(self):
        self.city = self.comboBox.currentText()
        self.des = self.comboBox_2.currentText()

        print(self.city, self.fix_date, self.des)

        self.cities, self.nums = csv_des.sum(self.city, self.fix_date, self.des)
        print(self.cities)
        print(self.nums)

        self.rows = self.cities
        self.header


if __name__ == '__main__':
    app = QApplication(sys.argv)
    window = MyWindow()
    window.show()
    sys.exit(app.exec_())
