import sys
from PyQt5.QtWidgets import *
from PyQt5 import uic
import pika
from PyQt5.QtCore import *
import socket
import json
import threading



class loginWindow(QWidget):
    def __init__(self):
        super().__init__()
        self.initUI()

    def initUI(self):
        self.setWindowTitle('채팅방 로그인')

        centerGeometry = QDesktopWidget().availableGeometry().center()
        self.resize(300, 100)
        frameGeometry = self.frameGeometry()
        frameGeometry.moveCenter(centerGeometry)

        idLabel = QLabel("아이디 : ")
        self.idLineEdit = QLineEdit()
        loginButton = QPushButton("로그인")

        layout = QGridLayout()

        layout.addWidget(idLabel, 0, 0)
        layout.addWidget(self.idLineEdit, 0, 1)
        layout.addWidget(loginButton, 0, 2)

        self.setLayout(layout)

        loginButton.clicked.connect(self.logged_in)


    def logged_in(self):
        self.cli_dict = dict()
        self.cli_dict['ID'] = self.idLineEdit.text()

        self.chatwindow = chatWindow()
        self.hide()
        self.chatwindow.show()


form = uic.loadUiType("qtdesign.ui")[0]

class chatWindow(QMainWindow, form):
    def __init__(self):
        super().__init__()
        self.setupUi(self)

        self.exchange_name = 'LeeHyunJin'

        connection = pika.BlockingConnection(
            pika.ConnectionParameters(host='183.99.87.90'))

        self.th = threading.Thread(target=self.worker, name="[스레드 이름 {}]")

        self.channel = connection.channel()
        result = self.channel.queue_declare(queue='')
        self.queue_name = result.method.queue

        self.channel.queue_bind(exchange=self.exchange_name,
                                queue=self.queue_name,
                                routing_key="key")

        self.channel.basic_consume(
            queue=self.queue_name, on_message_callback=self.callback)


        self.ID = logwindow.cli_dict['ID']
        self.pushButton.clicked.connect(self.button2Clicked)

        self.th.start()
    def worker(self):
        self.channel.start_consuming()


    def button2Clicked(self):
        self.msg = self.ID+":"+self.lineEdit.text()+"\n"
        self.channel.basic_publish(exchange=self.exchange_name, routing_key='key', body= self.msg)
        self.lineEdit.clear()


    def callback(self,ch, method, properties, body):
        self.body = body.decode('utf-8')
        print("%s:%s" % (method.routing_key, self.body))
        self.plainTextEdit.insertPlainText(self.body)

if __name__ == "__main__":
    app = QApplication(sys.argv)
    logwindow = loginWindow()
    logwindow.show()
    sys.exit(app.exec_())












# import requests
# from bs4 import BeautifulSoup  # BeautifulSoup import
# from konlpy.tag import Kkma
# import t
# kkma = Kkma()
# def ana(a,d):
#     ur = a
#     response = requests.get(headers={'User-Agent': 'Mozilla/5.0'},url=ur)
#     html = response.text
#     soup = BeautifulSoup(html, 'html.parser')  # html.parser를 사용해서 soup에 넣겠다
#     for tag in soup.select('div[id=dic_area]'):
#         t1=tag.text
#     mo = kkma.morphs(t1)
#
#
#     b=t.news2(mo ,d)
#
#     return b