import sys
import sys
from PyQt5.QtWidgets import *
from PyQt5.QtCore import *
from PyQt5.QtCore import QDate
from PyQt5.QtWidgets import *
from PyQt5 import uic
from fourdipyqtdb import findcity, buildtabledate

form = uic.loadUiType("4dd.ui")[0]


class MyWindow(QMainWindow, form):
    def __init__(self):
        super().__init__()
        self.setupUi(self)
        self.date = ""
        self.disease = ""
        self.city = ""

        self.pushButton.clicked.connect(self.click)

        self.comboBox.addItems(["감기", "눈병", "천식", "피부염"])
        self.comboBoxChanged('감기')

        self.comboBox_2.addItems(findcity())
        self.comboBoxChanged2("서울")

        self.comboBox.currentTextChanged.connect(self.comboBoxChanged)
        self.comboBox_2.currentTextChanged.connect(self.comboBoxChanged2)

        self.calendarWidget.clicked[QDate].connect(self.changeDate)

        self.label.setText("설정후 확인버튼을 눌러주세요.")
        self.calendarWidget.setDateRange(QDate(2014, 1, 1), QDate(2014, 2, 9))
        self.changeDate(QDate(2014, 1, 1))








    def comboBoxChanged(self, text):

        self.disease=text#disease
        print(self.disease)

    def comboBoxChanged2(self, text):

        self.city=text#city
        print(self.city)

    def changeDate(self, date):
        self.datee=date.toString()
        self.date = self.datee.split()[3]+self.datee.split()[1].zfill(2)+self.datee.split()[2].zfill(2)
        print(self.date)#date

    def click(self):
        print(1)
        a = buildtabledate(self.city, self.date, self.disease)
        print(a)
        self.rows = a

        print(a)
        headers = ['지역명', '발생숫자(명)']
        print(self.rows)
        self.tableWidget.setRowCount(len(self.rows))
        self.tableWidget.setColumnCount(len(headers))
        self.tableWidget.setEditTriggers(QAbstractItemView.NoEditTriggers)
        self.tableWidget.setHorizontalHeaderLabels(headers)
        self.setTableWidgetData()
        self.label.setText("검색 완료!")


    def setTableWidgetData(self):
        for b in range(len(self.rows)):
            for c in range(len(self.rows[b])):
                item = QTableWidgetItem(str(self.rows[b][c]))
                self.tableWidget.setItem(b, c, item)

        self.tableWidget.resizeColumnsToContents()
        self.tableWidget.resizeRowsToContents()



if __name__ == '__main__':
    app = QApplication(sys.argv)
    window = MyWindow()
    window.show()
    sys.exit(app.exec_())