import sys
from PyQt5.QtWidgets import *
from PyQt5.QtCore import *


class MyWindow(QWidget):
    def __init__(self):
        super().__init__()
        self.initUI()

    def initUI(self):
        self.rows = [
            ['1'],
            ['2']

        ]
        headers = ['No.']

        centerGeometry = QDesktopWidget().availableGeometry().center()
        self.resize(300, 200)
        frameGeometry = self.frameGeometry()
        frameGeometry.moveCenter(centerGeometry)

        self.tableWidget = QTableWidget(self)
        self.tableWidget.setRowCount(len(self.rows))
        self.tableWidget.setColumnCount(len(headers))
        self.tableWidget.setEditTriggers(QAbstractItemView.NoEditTriggers)

        self.tableWidget.setHorizontalHeaderLabels(headers)
        self.setTableWidgetData()

        label = QLabel("우리집 고양이", self)

        layout = QVBoxLayout()
        layout.addWidget(label)
        layout.addWidget(self.tableWidget)

        self.setLayout(layout)

    def setTableWidgetData(self):
        for b in range(len(self.rows)):
            for c in range(len(self.rows[b])):
                item = QTableWidgetItem(self.rows[b][c])
                btn = QPushButton()
                btn.setText('12/1/12')
                if c == 0:
                    item.setTextAlignment(Qt.AlignRight)
                self.tableWidget.setItem(b, c, item)
                self.tableWidget.setCellWidget(b, c, btn)





        self.tableWidget.resizeColumnsToContents()
        self.tableWidget.resizeRowsToContents()


if __name__ == "__main__":
    app = QApplication(sys.argv)
    window = MyWindow()
    window.show()
    sys.exit(app.exec_())