import sys
from PyQt5.QtWidgets import *
from PyQt5.QtCore import *


class MyWindow(QMainWindow):
    def __init__(self):
        super().__init__()
        self.initUI()

    def initUI(self):
        self.setWindowTitle('SWH Academy Window.')
        self.setGeometry(200, 200, 360, 150)

        self.label = QLabel("", self)
        self.label.move(50, 20)
        self.label.resize(220, 60)

        self.checkBox1 = QCheckBox("SWH Academy ", self)
        self.checkBox1.move(20, 90)
        self.checkBox1.setChecked(True)
        self.checkBox1.stateChanged.connect(self.checkBoxState)

        self.checkBox2 = QCheckBox("Coding ", self)
        self.checkBox2.move(140, 90)
        self.checkBox2.stateChanged.connect(self.checkBoxState)

        self.checkBox3 = QCheckBox("WorldHistory ", self)
        self.checkBox3.move(220, 90)
        self.checkBox3.stateChanged.connect(self.checkBoxState)

        self.checkBoxState()

    def checkBoxState(self):
        message = ""
        if self.checkBox1.isChecked():
            message += self.checkBox1.text();
        if self.checkBox2.isChecked():
            message += self.checkBox2.text();
        if self.checkBox3.isChecked():
            message += self.checkBox3.text();

        self.label.setText(message)


if __name__ == "__main__":
    app = QApplication(sys.argv)
    window = MyWindow()
    window.show()
    sys.exit(app.exec_())