import sys
import pymysql.cursors
from PyQt5.QtWidgets import *
from PyQt5.QtCore import *
from PyQt5.QtCore import QDate
from PyQt5.QtWidgets import *
from PyQt5 import uic
from news_pyqt_dbdate import buildtabledate
import webbrowser
form = uic.loadUiType("news_.ui")[0]

class MyWindow(QMainWindow, form):
    def __init__(self):
        super().__init__()
        self.setupUi(self)
        self.date=""

        self.pushButton.clicked.connect(self.click)

        self.comboBox.addItems(["정치_일반", "경제_일반", "사회_일반"])
        self.comboBoxChanged("정치_일반")
        self.comboBox.currentTextChanged.connect(self.comboBoxChanged)

        self.dateEdit.setMinimumDate(QDate(2022, 1, 1))
        self.dateEdit.setMaximumDate(QDate(2022, 12, 31))

        self.dateEdit.dateChanged.connect(self.dateEditChanged)
        self.dateEditChanged(QDate(2022, 1, 1))

    def comboBoxChanged(self, text):

        self.category=text #category
        print(self.category)

    def dateEditChanged(self, text):
        self.date = text  # date
        print(self.date)
        print(int(self.date.toString("yyyyMMdd")))
        a = self.date.toString("yyyyMMdd")
        self.b=a[:4]+"."+a[4:6]+"."+a[6:]

        if int(self.date.toString("yyyyMMdd"))>20221003 or int(self.date.toString("yyyyMMdd")) < 20221001:
            self.pushButton.setDisabled(True)
            self.label_2.setText("범위를 벗어났습니다.")
        else:
            self.pushButton.setDisabled(False)
            self.label_2.setText("설정후 완료버튼을 눌러주세요.")

    def click(self):
        self.A = buildtabledate(self.b, self.category)
        headers = ['제공회사', '제목', '수정날짜',"링크"]
        self.tableWidget.setRowCount(len(self.A))
        self.tableWidget.setColumnCount(len(headers))
        self.tableWidget.setHorizontalHeaderLabels(headers)

        for b in range(len(self.A)):
            for c in range(len(self.A[b])-1):
                btn = QPushButton("버튼")
                btn.clicked.connect(self.btn_fun)
                item = QTableWidgetItem(self.A[b][c])
                self.tableWidget.setItem(b, c, item)
                if c == 2:
                    self.tableWidget.setCellWidget(b, c+1, btn)

        self.tableWidget.resizeColumnsToContents()
        self.tableWidget.resizeRowsToContents()

        print("검색 완료!")
        self.label_2.setText("검색 완료!")

    def btn_fun(self):
        button = self.sender()
        item = self.tableWidget.indexAt(button.pos())
        webbrowser.open(self.A[item.row()][3])

if __name__ == '__main__':
    app = QApplication(sys.argv)
    window = MyWindow()
    window.show()
    sys.exit(app.exec_())