import threading
import time

""" 클래스 생성시 threading.Thread를 상속 """
class Worker(threading.Thread):
    def __init__(self, args, name=""):
        """ 생성자에서 threading.Thread를 초기화 """
        super().__init__()
        self.name = name
        self.args = args

    """ start()시 수행 """
    def run(self):
        print("{} 실행 중 : {}".format(threading.currentThread().getName(), self.args))
        time.sleep(3)
        print("{} 종료".format(threading.currentThread().getName()))

def main():
    for i in range(10):
        msg = "함수형 스레드 {}".format(i)
        """ threading.Thread 대신, 클래스명으로 스레드 객체 생성 """
        th = Worker(name="[스레드 이름 {}]".format(i), args=msg)
        th.start()  # run()이 수행

if __name__ == "__main__":
    main()