package kr.co.swh.lecture.springboot.l1.httpclient;

import java.io.IOException;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import com.google.gson.Gson;

import kr.co.swh.lecture.springboot.dvo.Student;

public class L1_1_4_HttpClientPostExample {
	public static void main(String[] args) {
		HttpClient client = HttpClients.createDefault();
		HttpPost request = new HttpPost("http://localhost:8000/api/l1/one/consumes/json");
		try {
			request.addHeader("Content-type", "application/json");
			
			Student student = new Student();
    		student.setName("레종");
    		student.setAge(11);
    		
			Gson gson = new Gson();
			
			//	수정할 데이터
			HttpEntity entity = new StringEntity(gson.toJson(student));
			request.setEntity(entity);
			
			//	전송
			HttpResponse response = client.execute(request);
			
			//	응답
			String result = EntityUtils.toString(response.getEntity());
			System.out.println(result);
			
			for(Header header : response.getAllHeaders()) {
				System.out.println("Res: " + header.getName() + " : " + header.getValue());
			}
			
		} catch (IOException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		}
	}
}