package kr.co.swh.lecture.springboot.l1;
 

import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

import kr.co.swh.lecture.springboot.dvo.Student;

@RestController
public class L1_1_GetOne_Controller {

    @GetMapping("/api/l1/one")
    public Student getStudent() {

        Student student = new Student();
        student.setName("코야");
        student.setAge(7);
        
        return student;
    }
    
    
//		1. produces는 반환하는 데이터 타입
//		2. 이럴 경우 반환 타입이 json으로 강제(내가 보내야 하는 타입이 정해져 있다면 해당 부분을 정의)
//		3. 요청하는 입장에서 특정 타입의 데이터를 원한다면 아래와 같은 내용을 헤더에 추가
//			Accept:application/json
	@GetMapping(path = "/api/l1/one/produces/json", produces = MediaType.APPLICATION_JSON_VALUE)
	public Student getStudentProducesJson() {
	
	  Student student = new Student();
	  student.setName("코야");
	  student.setAge(7);
	  
	  return student;
	}
    
//		1. consumes는 들어오는 데이터 타입
//		2. uri를 호출하는 쪽에서는 헤더에 보내는 데이터가 json이라는 것을 명시
//			Content-Type:application/json
    @PostMapping(path = "/api/l1/one/consumes/json", consumes = MediaType.APPLICATION_JSON_VALUE)
    public Student getStudentConsumesJson(Student student) {

        student.setName("코야");
        student.setAge(7);
        
        return student;
    }

    
}